
#ifndef MAX_NITROUS
#define MAX_NITROUS
#endif

// The following are non-varying state parameters, which should be set by the application at runtime
float4 __scene_ambient      : Ambient <string UIName = "Scene Ambient"; string UIWidget = "color";> = float4(0.0,0.0,0.0,1.0);
bool   __orthographic       : Orthographic = false;
float  __focal_length       : Focal_length = .5;
float  __aperture           : Aperture = 0.0;
int    __image_x_resolution : Image_x_resolution = 256;
int    __image_y_resolution : Image_y_resolution = 256;
float2 rasteroffset         : raster_offset = float2(0.5f, 0.5f);
float  __refracted_ior = 1.0;

#ifndef __LIGHT_ITERATOR_STRUCT
#define __LIGHT_ITERATOR_STRUCT
struct Light_iterator {
    float3 msl_point;
    float3 msl_direction;
    float  msl_distance;
    float  msl_dot_nl;
    float3 msl_contribution;
    float3 msl_raw_contribution;
    float3 msl_shadow;
    int    msl_count;
};
#endif // __LIGHT_ITERATOR_STRUCT

#ifndef __FLOAT3_CTOR
#define __FLOAT3_CTOR
float3 __float3_ctor(float v)
{
    return v.xxx;
}

#endif // __FLOAT3_CTOR

#ifndef __FLOAT4_CTOR
#define __FLOAT4_CTOR
float4 __float4_ctor(float v)
{
    return v.xxxx;
}

#endif // __FLOAT4_CTOR

#ifndef __IRRADIANCE_OPTIONS_TYPE
#define __IRRADIANCE_OPTIONS_TYPE
struct Irradiance_options
{
    float near;
    float far;
};

#endif // __IRRADIANCE_OPTIONS_TYPE

#ifndef __DIFFERENTIAL_SCALE
#define __DIFFERENTIAL_SCALE
uniform float __differential_scale = 1.0;

#endif // __DIFFERENTIAL_SCALE

#ifndef __GRID_SNAP_2D
#define __GRID_SNAP_2D

float2 _grid_snap(float4 props, float2 coord)
{
	return (floor(props.xy * coord) + 0.5) / props.xy;
}

#endif // __GRID_SNAP_2D

#ifndef __GRID_SNAP_3D
#define __GRID_SNAP_3D

float3 _grid_snap(float4 props, float3 coord)
{
    return (floor(props.xyz * coord) + 0.5) / props.xyz;
}

#endif // __GRID_SNAP_3D

#ifndef __TEXTURE_FLIP
#define __TEXTURE_FLIP

float2 __flip_v(float2 v) { return float2(v.x, -v.y); }
float3 __flip_v(float3 v) { return float3(v.x, -v.y, v.z); }
float4 __flip_v(float4 v) { return float4(v.x, -v.y, v.z, v.w); }

#endif // __TEXTURE_FLIP